Inspect all docker volumes

```bash
$ docker volume ls
DRIVER    VOLUME NAME
local     2b85855560fe1ca6bf9e28e0a5c56684299154af2abd7ad6e938a98ab2170e8e
local     155b4a28b32892053649ffad905245c0bfa35a5e577741e3d02121c6d50b7911
local     a10bfb4492bdb3a9979fb3a292f75c4455e2e554c368c57e232649d971361e0d
local     b89ab29344346fe963edb231cbbb6583823552f58069772e4eb27e4a456a8665
```

```bash
$ docker volume ls | awk 'NR > 1 {print $2}'
2b85855560fe1ca6bf9e28e0a5c56684299154af2abd7ad6e938a98ab2170e8e
155b4a28b32892053649ffad905245c0bfa35a5e577741e3d02121c6d50b7911
a10bfb4492bdb3a9979fb3a292f75c4455e2e554c368c57e232649d971361e0d
b89ab29344346fe963edb231cbbb6583823552f58069772e4eb27e4a456a8665
```

```bash
$ docker volume ls | awk 'NR > 1 {print $2}' | xargs docker volume inspect
[
    {
        "CreatedAt": "2024-07-29T15:41:23Z",
        "Driver": "local",
        "Labels": {
            "com.docker.volume.anonymous": ""
        },
        "Mountpoint": "/var/lib/docker/volumes/2b85855560fe1ca6bf9e28e0a5c56684299154af2abd7ad6e938a98ab2170e8e/_data",
        "Name": "2b85855560fe1ca6bf9e28e0a5c56684299154af2abd7ad6e938a98ab2170e8e",
        "Options": null,
        "Scope": "local"
    },
    {
        "CreatedAt": "2024-07-29T16:07:35Z",
        "Driver": "local",
        "Labels": {
            "com.docker.volume.anonymous": ""
        },
        "Mountpoint": "/var/lib/docker/volumes/155b4a28b32892053649ffad905245c0bfa35a5e577741e3d02121c6d50b7911/_data",
        "Name": "155b4a28b32892053649ffad905245c0bfa35a5e577741e3d02121c6d50b7911",
        "Options": null,
        "Scope": "local"
    },
    {
        "CreatedAt": "2024-07-29T15:41:23Z",
        "Driver": "local",
        "Labels": {
            "com.docker.volume.anonymous": ""
        },
        "Mountpoint": "/var/lib/docker/volumes/a10bfb4492bdb3a9979fb3a292f75c4455e2e554c368c57e232649d971361e0d/_data",
        "Name": "a10bfb4492bdb3a9979fb3a292f75c4455e2e554c368c57e232649d971361e0d",
        "Options": null,
        "Scope": "local"
    },
    {
        "CreatedAt": "2024-07-29T16:07:35Z",
        "Driver": "local",
        "Labels": {
            "com.docker.volume.anonymous": ""
        },
        "Mountpoint": "/var/lib/docker/volumes/b89ab29344346fe963edb231cbbb6583823552f58069772e4eb27e4a456a8665/_data",
        "Name": "b89ab29344346fe963edb231cbbb6583823552f58069772e4eb27e4a456a8665",
        "Options": null,
        "Scope": "local"
    }
]
```
