; boot2.asm
; nasm -f bin boot2.asm -o boot2.img
; qemu-system-i386 -drive format=raw,file=boot2.img

[org 0x7c00]
bits 16

start:
    cli
    xor ax, ax
    mov ds, ax
    mov es, ax

    ; --- 1) 切换到 320×200 256 色模式 (mode 13h) ---
    mov ah, 0x00
    mov al, 0x13
    int 0x10

    ; --- 2) 清屏（黑色） ---
    mov ax, 0xA000
    mov es, ax
    xor di, di
    mov al, 0
    mov cx, 320*200
    rep stosb

    ; --- 3) 绘制灰色圆 ---
    call draw_circle

    jmp $

; -------------------------------------------------------
; draw_circle: 在 (160,100) 处以半径 80 画灰色圆
; -------------------------------------------------------
draw_circle:
    mov cx, 80        ; radius = 80
    xor dx, dx        ; x = 0
    mov bx, cx        ; y = radius
    mov ax, 1
    sub ax, cx        ; d = 1 - radius

circ_loop:
    ; 画出 8 个对称点
    call plot_octants

    ; 更新决策变量 d
    ; temp = 4*x
    mov si, dx
    add si, si
    add si, si

    cmp ax, 0
    jl d_negative
    ; d >= 0
    mov di, bx
    add di, di
    add di, di       ; di = 4*y
    sub si, di       ; si = 4*(x - y)
    add si, 10
    dec bx           ; y--
    jmp d_update

d_negative:
    ; d < 0
    add si, 6

d_update:
    add ax, si       ; d += si
    inc dx           ; x++
    cmp dx, bx
    jle circ_loop
    ret

; -------------------------------------------------------
; plot_octants: 将 (dx, bx) 对称的 8 点传入 plot_pixel
;   入口：DX=x, BX=y
; -------------------------------------------------------
plot_octants:
    ; 保存通用寄存
    push ax
    push bx
    push cx
    push dx
    push si
    push di

    ; ( x,  y)
    mov si, dx
    mov di, bx
    call plot_pixel

    ; ( y,  x)
    mov si, bx
    mov di, dx
    call plot_pixel

    ; (-x,  y)
    mov si, dx
    neg si
    mov di, bx
    call plot_pixel

    ; (-y,  x)
    mov si, bx
    neg si
    mov di, dx
    call plot_pixel

    ; (-x, -y)
    mov si, dx
    neg si
    mov di, bx
    neg di
    call plot_pixel

    ; (-y, -x)
    mov si, bx
    neg si
    mov di, dx
    neg di
    call plot_pixel

    ; ( x, -y)
    mov si, dx
    mov di, bx
    neg di
    call plot_pixel

    ; ( y, -x)
    mov si, bx
    mov di, dx
    neg di
    call plot_pixel

    ; 恢复寄存
    pop di
    pop si
    pop dx
    pop cx
    pop bx
    pop ax
    ret

; -------------------------------------------------------
; plot_pixel:
;   SI = x 偏移 (signed), DI = y 偏移 (signed)
;   在中心 (160,100) 上绘制一个灰色像素 (palette index = 7)
; -------------------------------------------------------
plot_pixel:
    push ax
    push bx
    push cx
    push dx

    ; 计算 px = 160 + SI, py = 100 + DI
    mov ax, 160
    add ax, si      ; px
    mov cx, 100
    add cx, di      ; py

    ; offset = py*320 + px = (py<<8)+(py<<6)+px
    mov bx, cx
    shl bx, 8
    mov di, bx
    mov bx, cx
    shl bx, 6
    add di, bx
    add di, ax

    mov al, 7       ; gray
    mov [es:di], al

    pop dx
    pop cx
    pop bx
    pop ax
    ret

times 510-($-$$) db 0
dw 0xAA55

