#include <pthread.h>
#include <stdio.h>
#include <unistd.h>

pthread_mutex_t lock_a = PTHREAD_MUTEX_INITIALIZER;
pthread_mutex_t lock_b = PTHREAD_MUTEX_INITIALIZER;

int shared_data = 0;

void* thread_func1(void* arg) {
    pthread_mutex_lock(&lock_a);
    printf("Thread 1 acquired lock A\n");
    shared_data += 1;  // 写入共享数据
    sleep(1);
    pthread_mutex_lock(&lock_b);
    printf("Thread 1 acquired lock B\n");
    shared_data += 1;

    pthread_mutex_unlock(&lock_b);
    pthread_mutex_unlock(&lock_a);
    return NULL;
}

void* thread_func2(void* arg) {
    pthread_mutex_lock(&lock_b);
    printf("Thread 2 acquired lock B\n");
    shared_data += 1;
    sleep(1);
    pthread_mutex_lock(&lock_a);
    printf("Thread 2 acquired lock A\n");
    shared_data += 1;

    pthread_mutex_unlock(&lock_a);
    pthread_mutex_unlock(&lock_b);
    return NULL;
}


int main() {
    pthread_t t1, t2;

    pthread_create(&t1, NULL, thread_func1, NULL);
    pthread_create(&t2, NULL, thread_func2, NULL);

    pthread_join(t1, NULL);
    pthread_join(t2, NULL);

    printf("Done.\n");
    return 0;
}
