#!/bin/bash

# --- 1. Configuration (Critical!) ---

# These values are observed from your browser. They will likely expire!
# When the script fails, you may need to re-capture these two values from your browser.
FINGERPRINT="ZSbU9jU2AZWgnNagZ61vVua0RCZr46DT5eSwn8uHKsc8QFEFBhTVYPI7a1LWcrDAwOm%2F4AGv7rmTw%2F4xVTQqgA%3D%3D"
RANDOM_STRING="SDQwjPd54R84tGaackbWmYNme4tmsD75"

# Your User-Agent
USER_AGENT="Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36"

# !! Fill in the Referer and Origin from your "Copy as cURL"
# !! These two headers are crucial for preventing 403 Forbidden errors
REFERER_HEADER="https://hitools.hikvision.com/en/some-page-you-were-on"
ORIGIN_HEADER="https://hitools.hikvision.com"
# Check if 'X-Requested-With: XMLHttpRequest' is also in your 'Copy as cURL'
X_REQ_WITH_HEADER="XMLHttpRequest"


# --- 2. Preparation ---

# Create a secure temporary file to store cookies
COOKIE_JAR=$(mktemp)

# Ensure the cookie file is deleted on script exit
trap "rm -f $COOKIE_JAR" EXIT

# Your API URLs
GET_SESSION_URL="https://hitools.hikvision.com/TSAPI/User?fingerprint=${FINGERPRINT}&r=${RANDOM_STRING}&platform=indepLink&area=Global"
POST_PRODUCT_URL="https://hitools.hikvision.com/en/TSAPI/ESServe/v2/products"

# Your JSON data
JSON_PAYLOAD='{
    "bool": {
        "or": {
            "term": [
                {
                    "key": "productBaseInfo.productSapId.keyword",
                    "value": "311326558"
                }
            ]
        }
    },
    "productBracket": true
}'


# --- 3. Step 1: Get Session ---

echo "Getting session..."
# -s: Silent mode
# -L: Follow redirects
# -c: (cookie jar) Write cookies to the $COOKIE_JAR file
# We also need to add UA and Referer to this GET request to simulate a browser
curl -s -L \
  -A "$USER_AGENT" \
  -H "Referer: $REFERER_HEADER" \
  -H "Origin: $ORIGIN_HEADER" \
  -H "X-Requested-With: $X_REQ_WITH_HEADER" \
  -c "$COOKIE_JAR" \
  "$GET_SESSION_URL"

# Check if the cookie file is empty
if [ ! -s "$COOKIE_JAR" ]; then
    echo "Failed to get session! Cookie file is empty."
    exit 1
fi

echo "Session and Cookies saved to: $COOKIE_JAR"
# You can inspect the cookies by uncommenting the next line
# cat $COOKIE_JAR


# --- 4. Step 2: POST Data Using the Session ---

echo "POSTing data..."
# -b: (cookie) Read cookies from the $COOKIE_JAR file
curl -X POST \
  -b "$COOKIE_JAR" \
  -A "$USER_AGENT" \
  -H "Content-Type: application/json" \
  -H "Referer: $REFERER_HEADER" \
  -H "Origin: $ORIGIN_HEADER" \
  -H "X-Requested-With: $X_REQ_WITH_HEADER" \
  -d "$JSON_PAYLOAD" \
  "$POST_PRODUCT_URL"

echo
echo "Script execution finished."