#!/usr/bin/env bash
set -euo pipefail

# 要检查的命令列表（包含常用的系统管理、文件操作、网络诊断等）
cmds=(
  # 原有命令
  ls type which make uname lsb_release usermod nano apt sudo
  dirname basename yes printf stat diff patch dpkg dpkg-query apt-cache
  rsync id groups smartctl mkfs.ext4 strace nmap nc rsync
  tar xz gzip file less w who whoami scp
  lspci lsusb lsblk fdisk df free top htop ip ping curl wget
  zip unzip xargs tar time zstd ssh adduser ufw man
  mount umount systemctl journalctl dmesg hostname hostnamectl
  cat echo grep awk sed cut find ps less kmod iptables ip6tables
  netstat ss route tcpdump du chmod chown cp mv rm mkdir rmdir ln touch
  useradd userdel groupadd groupdel passwd su sudo env uname whoami
  uptime date lsof vmstat iostat traceroute host dig
  tail head watch logger crontab ifconfig
)

for cmd in "${cmds[@]}"; do
  if ! command -v "$cmd" >/dev/null 2>&1; then
    echo "ERROR: Required command '$cmd' not found in \$PATH!" >&2
    exit 1
  fi
done

echo "✅ 系统健康检查通过：所有常用命令都可用。"
