#!/usr/bin/env bash
#
# compare_packages.sh
#
# Compare package lists from two systems:
#   anduinos-packages.txt
#   ubuntu-24-packages.txt

# Ensure both files exist
if [[ ! -f "anduinos-packages.txt" || ! -f "ubuntu-24-packages.txt" ]]; then
  echo "Error: One or both package list files are missing."
  echo "Please make sure anduinos-packages.txt and ubuntu-24-packages.txt are present."
  exit 1
fi

echo "===== Packages installed on anduinos but NOT on ubuntu ====="
comm -23 <(sort anduinos-packages.txt) <(sort ubuntu-24-packages.txt)

echo
echo "===== Packages installed on ubuntu but NOT on anduinos ====="
comm -13 <(sort anduinos-packages.txt) <(sort ubuntu-24-packages.txt)

echo
echo "Comparison done."
