    //<PackageReference Include="Aiursoft.AiurObserver.Command" Version="8.0.4" />
    //<PackageReference Include="Aiursoft.AiurObserver.Extensions" Version="8.0.3" />
    //<PackageReference Include="Microsoft.Extensions.Logging.Console" Version="8.0.1" />

using Aiursoft.AiurObserver;
using Aiursoft.AiurObserver.Command;
using Microsoft.Extensions.Logging;
using Aiursoft.AiurObserver.Extensions;

namespace Moni;

public abstract class Program
{
    private BlockRule[] _rules = new[]
    {
        // 8MiB/s, 80MiB in 10 seconds
        new BlockRule
        {
            MaxBytesTransferred = 0x500_0000,
            IntervalSeconds = 10
        },
        // 6MiB/s, 360MiB in 60 seconds
        new BlockRule
        {
            MaxBytesTransferred = 0x1680_0000,
            IntervalSeconds = 60
        },
        // 5MiB/s, 1500MiB in 300 seconds (5 minutes)
        new BlockRule
        {
            MaxBytesTransferred = 0x5DC0_0000,
            IntervalSeconds = 300
        },
        // 4MiB/s, 2400MiB in 600 seconds (10 minutes)
        new BlockRule
        {
            MaxBytesTransferred = 0x9600_0000,
            IntervalSeconds = 600
        },
        // 3MiB/s, 3600MiB in 1200 seconds (20 minutes)
        new BlockRule
        {
            MaxBytesTransferred = 0xE10_0000,
            IntervalSeconds = 1200
        }
    };

    private static Dictionary<string, long> IpTrafficUsage { get; } = new();
    
    public static async Task Main(string[] args)
    {
        if (args.Length != 1)
        {
            Console.WriteLine("Please provide the network interface name.");
            return;
        }
        
        var interfaceName = args[0];
        
        var logger = LoggerFactory.Create(logging => logging.AddConsole()).CreateLogger<LongCommandRunner>();
        var runner = new LongCommandRunner(logger);

        // Returns every 10 seconds
        runner.Output.InNewThread().Subscribe(OnLog);
        
        await runner.Run(
            bin: "/usr/bin/bash",
            arg: $"/usr/local/bin/moninet {interfaceName}",
            path: "/");
    }

    private static Task OnLog(string rawOutput)
    {
        var outputLines = rawOutput.Split("\n");
        foreach (var line in outputLines.Select(outputLine => outputLine.Trim()))
        {
            if (line.StartsWith("IP Address")) continue;
            if (line.StartsWith("===")) continue;
            var parts = line.Split(" ", StringSplitOptions.RemoveEmptyEntries)
                .Select(part => part.Trim())
                .ToArray();
            if (parts.Length != 3) continue;

            var ipAddr = parts[0];
            var download = long.Parse(parts[1]);
            var upload = long.Parse(parts[2]);
            Console.WriteLine($"In the past 10 seconds, remote IP {ipAddr} downloaded {download} bytes and uploaded {upload} bytes.");
            var totalTraffic = download + upload;
            IpTrafficUsage[ipAddr] = IpTrafficUsage.TryGetValue(ipAddr, out var usage) ? usage + totalTraffic : totalTraffic;
        }

        return Task.CompletedTask;
    }
}

public class BlockRule
{
    public long MaxBytesTransferred { get; set; }
    
    public int IntervalSeconds { get; set; }
}